<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mission extends Model 
{

    protected $table = 'missions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'type', 'in_office', 'start_period', 'duration', 'description', 'status', 'phone_number', 'is_whatsApp', 'company_name', 'company_size', 'user_id');

    public function skills()
    {
        return $this->belongsToMany('App\Models\Skill');
    }

}